"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeGraphWatch = executeGraphWatch;
exports.executeGraphWatchRoute = executeGraphWatchRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function executeGraphWatch({
  clusterClient,
  logger
}) {
  return async function (context, request, response) {
    try {
      const {
        body: {
          request: {
            indices: index,
            body
          }
        }
      } = request;
      const resp = await clusterClient.asScoped(request).asCurrentUser.search({
        body,
        index
      });
      return response.ok({
        body: {
          ok: true,
          resp
        }
      });
    } catch (err) {
      logger.error(`executeGraphWatch: ${err.stack}`);
      return response.customError((0, _errors.serverError)(err));
    }
  };
}
function executeGraphWatchRoute({
  router,
  clusterClient,
  logger
}) {
  router.post({
    path: `${_constants.ROUTE_PATH.WATCH}/_execute_graph`,
    validate: {
      body: _configSchema.schema.object({
        request: _configSchema.schema.object({
          indices: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
            defaultValue: []
          }),
          body: _configSchema.schema.object({}, {
            unknowns: 'allow',
            defaultValue: {}
          })
        }, {
          defaultValue: {
            indices: [],
            body: {}
          }
        })
      })
    }
  }, executeGraphWatch({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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